PXCAHF ;ISL/dee - Validates & Translates data from the PCE Device Interface into PCE's PXK format for Health Factors ;3/14/97
 ;;1.0;PCE PATIENT CARE ENCOUNTER;**27**;Aug 12, 1996
 Q
 ; Variables
 ;   PXCAHF  Copy of a HEALTH FACTORS node of the PXCA array
 ;   PXCAPRV   Pointer to the provider (200)
 ;   PXCANUMB  Count of the number if HFs
 ;   PXCAINDX  Count of the number of HEALTH FACTORS for one provider
 ;   PXCAFTER  Temp used to build ^TMP(PXCAGLB,$J,"HF",PXCANUMB,0,"AFTER")
 ;   PXCAPNAR  Pointer to the provider narrative (9999999.27)
 ;
HF(PXCAHF,PXCANUMB,PXCAPRV,PXCAERRS) ;
 N PXCAFTER
 S PXCAFTER=$P(PXCAHF,"^",1)_"^"_PXCAPAT_"^"_PXCAVSIT_"^"
 S PXCAFTER=PXCAFTER_$P(PXCAHF,"^",2)
 S ^TMP(PXCAGLB,$J,"HF",PXCANUMB,"IEN")=""
 S ^TMP(PXCAGLB,$J,"HF",PXCANUMB,0,"BEFORE")=""
 S ^TMP(PXCAGLB,$J,"HF",PXCANUMB,0,"AFTER")=PXCAFTER
 S ^TMP(PXCAGLB,$J,"HF",PXCANUMB,12,"BEFORE")=""
 S ^TMP(PXCAGLB,$J,"HF",PXCANUMB,12,"AFTER")="^^^"_$S(PXCAPRV>0:PXCAPRV,1:"")
 S ^TMP(PXCAGLB,$J,"HF",PXCANUMB,812,"BEFORE")=""
 S ^TMP(PXCAGLB,$J,"HF",PXCANUMB,812,"AFTER")="^"_PXCAPKG_"^"_PXCASOR
 Q
 ;
HFACTORS(PXCA,PXCABULD,PXCAERRS) ;Validation routine for HF
 Q:'$D(PXCA("HEALTH FACTORS"))
 N PXCAHF,PXCAPRV,PXCANUMB,PXCAINDX
 N PXCAITEM
 S PXCAPRV=""
 S PXCANUMB=0
 F  S PXCAPRV=$O(PXCA("HEALTH FACTORS",PXCAPRV)) Q:PXCAPRV']""  D
 . I PXCAPRV>0 D
 .. I '$$ACTIVPRV^PXAPI(PXCAPRV,PXCADT) S PXCA("ERROR","HEALTH FACTORS",PXCAPRV,0,0)="Provider is not active or valid^"_PXCAPRV
 .. E  I PXCABULD!PXCAERRS D ANOTHPRV^PXCAPRV(PXCAPRV)
 . S PXCAINDX=""
 . F  S PXCAINDX=$O(PXCA("HEALTH FACTORS",PXCAPRV,PXCAINDX)) Q:PXCAINDX']""  D
 .. S PXCAHF=$G(PXCA("HEALTH FACTORS",PXCAPRV,PXCAINDX))
 .. S PXCANUMB=PXCANUMB+1
 .. I PXCAHF="" S PXCA("ERROR","HEALTH FACTORS",PXCAPRV,PXCAINDX,0)="HEALTH FACTORS data missing" Q
 .. S PXCAITEM=+$P(PXCAHF,U,1)
 .. I $G(^AUTTHF(PXCAITEM,0))="" S PXCA("ERROR","HEALTH FACTORS",PXCAPRV,PXCAINDX,1)="HEALTH FACTORS type not in file 9999999.14^"_PXCAITEM
 .. S PXCAITEM=$P(PXCAHF,U,2)
 .. I '(PXCAITEM=""!(PXCAITEM="M")!(PXCAITEM="MO")!(PXCAITEM="H")) S PXCA("ERROR","HEALTH FACTORS",PXCAPRV,PXCAINDX,2)="HEALTH FACTORS level/severity must be M|MO|H^"_PXCAITEM
 .. I PXCABULD&'$D(PXCA("ERROR","HEALTH FACTORS",PXCAPRV,PXCAINDX))!PXCAERRS D HF(PXCAHF,.PXCANUMB,PXCAPRV,PXCAERRS)
 Q
 ;
